 ; Ŀ
 ;   Sev/Ves - check for changes to System Variables.                      
 ;   Copyright 2006, 2008 by Rocket Software Ltd.                          
 ;   Sev saves the system variables to a list and to a file named after    
 ;   the current drawing.                                                  
 ;   Ves reports which ones have changed since you last ran Sev.           
 ;   Vesf reports which ones are different from those in a selected        
 ;   file made with Sev.                                                    
 ;                                                                          
 ;   It's easier to make changes than to understand them.                  
 ; 

 ; Ŀ
 ;   Bottle - write a boxed file header.                                   
 ;   Takes no prisoners, returns nothing.                                  
 ;   Correction - takes one argument, a filename.                          
 ;   Further correction - takes another argument, list of strings to       
 ;   write, each on its own line.                                          
 ; 
 (DEFUN BOTTLE (lognam strlst / aa bb cc thestr newlst fn)
  (setq aa "")
  (setq bb (strcat " " aa aa ""))
  (setq cc (strcat " " aa aa ""))
  (while (setq thestr (car strlst))
         (setq strlst (cdr strlst))
         (setq thestr (strcat "   " thestr))
         (while (< (strlen thestr) 76) (setq thestr (strcat thestr " ")))
         (setq thestr (strcat thestr ""))
         (setq newlst (append newlst (list thestr))))
  (setq fn (open lognam "w"))
  (princ bb fn)
  (while (setq thestr (car newlst))
         (setq newlst (cdr newlst))
         (princ (strcat "\n" thestr) fn))
  (princ (strcat "\n" cc) fn)
  (close fn))
 ; Ŀ
 ;   Bottle end.                                                           
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Fstx - read a line from a file (a list written to a file with print)  
 ;   and make it back into a list.                                         
 ;   The list is made with Relish, which returns a list, so the full       
 ;   list:file:list cycle adds one more layer of listing, thus caadr must  
 ;   be used on the result: cadr to extract the list from the (now empty)  
 ;   string and list list, and car to remove the outer list.               
 ;   Modified: the file now consists of multiple lines, each containing    
 ;   one list, and a header.  Also want to allow for comments.             
 ; 
 (DEFUN FSTX (filnam / fn str lla llist)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq str (read-line fn))
                  (while (and (/= (substr str 1 1) "")
                              (= (substr str 1 1) " "))
                         (setq str (substr str 2)))
                  (if (null (member (substr str 1 1) (list ";" "" "" "")))
                      (progn
                           (setq llist (caadr (relish str)))
                           (if (= (length llist) 3)
                               (setq llist (list (car llist) (cadr llist))))
 ; Ŀ
 ;   Replace double backslashes in the string with backslashes.            
 ; 
                           (if (= (type (setq str (cadr llist))) 'STR)
                               (progn
                                    (setq str (car (chug "\\\\" "\\" str)))
                                    (setq llist (list (car llist) str))))
                           (setq lla (append lla (list llist))))))
           (close fn))
      (setq lla ()))
 lla)
 ; Ŀ
 ;   Fstx end.                                                             
 ; 

 ; Ŀ
 ;   Lisfi - save a list to a file named after the current drawing.        
 ;   Arguments: Liss, a list.                                              
 ;   Calls nothing, Returns nothing.                                       
 ; 
 (DEFUN LISFI (liss / filnam len tlis fn num sub)
 ; Ŀ
 ;   Make a directory path and name string without the extension.          
 ; 
  (setq filnam (strcat (getvar "dwgprefix") (getvar "dwgname")))
  (if (= (substr (strcase filnam t) (- (setq len (strlen filnam)) 3)) ".dwg")
      (setq filnam (substr filnam 1 (- len 4))))
  (setq filnam (strcat filnam ".svs"))
  (setq tlis (list (strcat "Sysvar data for " (getvar "dwgname") ".")
                   "This file was created by Sev.lsp."
                   ""))
  (bottle filnam tlis)
 ; Ŀ
 ;   Save the data to the file.                                            
 ; 
  (setq fn (open filnam "a"))
  (setq num 0)
  (while (setq sub (nth num liss))
         (print sub fn)
         (setq num (1+ num)))
  (close fn)
 (princ))
 ; Ŀ
 ;   Lisfi end.                                                            
 ; 

 ; Ŀ
 ;   Relish - make a text string into a list.                              
 ;   Takes one argument, a string.                                         
 ;   Returns the remainder of the string and a list.                       
 ; 
 (DEFUN RELISH (str / curvar achar strand nulst stop)
  (setq curvar "")
  (while (and (null stop) (> (strlen str) 0))
         (setq achar (substr str 1 1))
         (setq str (substr str 2))
         (cond ((= achar "(")
                (setq strand (relish str))
                (setq nulst (append nulst (list (cadr strand))))
                (setq str (car strand)))
               ((= achar ")")
                (while (= (substr str 1 1) " ")
                       (setq str (substr str 2)))
                 (setq stop t))
               ((= achar " ")
                (setq curvar (read curvar))
                (setq nulst (append nulst (list curvar)))
                (setq curvar ""))
               ((= achar "\"")
                (if (not (member curvar '("" " ")))
                    (progn
                         (setq curvar (read curvar))
                         (setq nulst (append nulst (list curvar)))
                         (setq curvar "")))
                (while (and (setq achar (substr str 1 1))
                            (setq str (substr str 2))
                            (/= achar "")
                            (/= achar "\""))
                       (if (/= achar "\"")
                           (setq curvar (strcat curvar achar))))
                (setq nulst (append nulst (list curvar)))
                (setq str (substr str 2))
                (setq curvar ""))
               (t
                (setq curvar (strcat curvar achar)))))
  (if (/= curvar "") 
      (setq nulst (append nulst (list (read curvar)))))
 (list str nulst))
 ; Ŀ
 ;   Relish end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Ves - see if any sysvars have changed.                     
 ;   Arguments: Sevals, ((sysvar val) ...)                                 
 ;              Fuzz, a fuzz factor for equal.  This is set higher when    
 ;                    the comparison uses a data from a file to avoid      
 ;                    roundoff errors during the write-read cycle.         
 ;   Subroutine Ves - see if any sysvars have changed.                     
 ; 
 (DEFUN VES (sevals fuzz / sub num seval sevar used)
  (setq num 0)
  (while (setq sub (nth num sevals))
         (setq num (1+ num))
         (setq seval (getvar (setq sevar (car sub))))
         (if (null seval) (setq seval "No value"))
         (if (and (not (equal (setq gnusub (list sevar seval)) sub fuzz))
                  (not (member sevar '("tdusrtimer" "tdindwg"
                                       "lastprompt" "date" "cdate"))))
             (progn
                  (if (null used)
                      (progn
                           (prompt "\nOld and New System Variable Values:")
                           (setq used t)))
                  (prompt "\n----------------")
                  (print sub)
                  (print gnusub))))
  (if (null used)
      (prompt "No changes to System Variables.\n"))
 (princ))
 ; Ŀ
 ;   Subroutine Ves end.                                                   
 ; 

 ; Ŀ
 ;   Sev - save the current values of all system variables.                
 ; 
 (DEFUN C:SEV (/ svlist sub num)
  (setq svlist '(
"acadlspasdoc" "acadprefix" "acadver" "acisoutver" "aflags" "angbase"
"angdir" "apbox" "aperture" "area" "attdia" "attmode" "attreq" "auditctl"
"aunits" "auprec" "autosnap" "backgroundplot" "backz" "bindtype" "blipmode"
"cdate" "cecolor" "celtscale" "celtype" "celweight" "chamfera" "chamferb"
"chamferc" "chamferd" "chammode" "circlerad" "clayer" "cleanscreenstate"
"cmdactive" "cmddia" "cmdecho" "cmdnames" "cmljust" "cmlscale" "cmlstyle"
"compass" "coords" "cplotstyle" "cprofile" "ctab" "ctablestyle" "cursorsize"
"cvport" "date" "dbmod" "dctcust" "dctmain" "deflplstyle" "defplstyle"
"delobj" "demandload" "diastat" "dimadec" "dimalt" "dimaltd" "dimaltf"
"dimaltrnd" "dimalttd" "dimalttz" "dimaltu" "dimaltz" "dimapost" "dimaso"
"dimassoc" "dimasz" "dimatfit" "dimaunit" "dimazin" "dimblk" "dimblk1"
"dimblk2" "dimcen" "dimclrd" "dimclre" "dimclrt" "dimdec" "dimdle" "dimdli"
"dimdsep" "dimexe" "dimexo" "dimfit" "dimfrac" "dimgap" "dimjust" "dimldrblk"
"dimlfac" "dimlim" "dimlunit" "dimlwd" "dimlwe" "dimpost" "dimrnd" "dimsah"
"dimscale" "dimsd1" "dimsd2" "dimse1" "dimse2" "dimsho" "dimsoxd" "dimstyle"
"dimtad" "dimtdec" "dimtfac" "dimtih" "dimtix" "dimtm" "dimtmove" "dimtofl"
"dimtoh" "dimtol" "dimtolj" "dimtp" "dimtsz" "dimtvp" "dimtxsty" "dimtxt"
"dimtzin" "dimunit" "dimupt" "dimzin" "dispsilh" "distance" "donutid"
"donutod" "dragmode" "dragp1" "dragp2" "draworderctl" "dwgcheck"
"dwgcodepage" "dwgname" "dwgprefix" "dwgtitled" "edgemode" "elevation"
"expert" "explmode" "extmax" "extmin" "extnames" "facetratio" "facetres"
"fielddisplay" "fieldeval" "filedia" "filletrad" "fillmode" "fontalt"
"fontmap" "frontz" "fullopen" "gfang" "gfclr1" "gfclr2" "gfclrlum"
"gfclrstate" "gfname" "gfshift" "gridmode" "gridunit" "gripblock" "gripcolor"
"griphot" "griphover" "gripobjlimit" "grips" "gripsize" "griptips" "halogap"
"handles" "hideprecision" "hidetext" "highlight" "hpang" "hpassoc" "hpbound"
"hpdouble" "hpdraworder" "hpgaptol" "hpname" "hpscale" "hpspace"
"hyperlinkbase" "imagehlt" "indexctl" "inetlocation" "insbase" "insname"
"insunits" "insunitsdefsource" "insunitsdeftarget" "intersectioncolor"
"intersectiondisplay" "isavebak" "isavepercent" "isolines" "lastangle"
"lastpoint" "lastprompt" "layoutregenctl" "lenslength" "limcheck" "limmax"
"limmin" "lispinit" "locale" "localrootprefix" "logfilemode" "logfilename"
"logfilepath" "loginname" "ltscale" "lunits" "luprec" "lwdefault" "lwdisplay"
"lwunits" "maxactvp" "maxsort" "mbuttonpan" "measureinit" "measurement"
"menuctl" "menuecho" "menuname" "millisecs" "mirrtext" "modemacro"
"msolescale" "mtexted" "mtextfixed" "mtjigstring" "mydocumentsprefix"
"nomutt" "obscuredcolor" "obscuredltype" "offsetdist" "offsetgaptype"
"oleframe" "olehide" "olequality" "olestartup" "orthomode" "osmode"
"osnapcoord" "osnaphatch" "paletteopaque" "paperupdate" "pdmode" "pdsize"
"peditaccept" "pellipse" "perimeter" "pfacevmax" "pickadd" "pickauto"
"pickbox" "pickdrag" "pickfirst" "pickstyle" "platform" "plinegen"
"plinetype" "plinewid" "plotoffset" "plotrotmode" "plquiet" "polaraddang"
"polarang" "polardist" "polarmode" "polysides" "popups" "projectname"
"projmode" "proxygraphics" "proxynotice" "proxyshow" "proxywebsearch"
"psltscale" "psprolog" "psquality" "pstylemode" "pstylepolicy" "psvpscale"
"pucsbase" "qtextmode" "rasterdpi" "rasterpreview" "refeditname" "regenmode"
"rememberfolders" "reporterror" "roamablerootprefix" "rtdisplay" "savefile"
"savefilepath" "savename" "savetime" "screenboxes" "screenmode" "screensize"
"sdi" "shadedge" "shadedif" "shortcutmenu" "shpname" "sigwarn" "sketchinc"
"skpoly" "snapang" "snapbase" "snapisopair" "snapmode" "snapstyl" "snaptype"
"snapunit" "solidcheck" "sortents" "splframe" "splinesegs" "splinetype"
"ssfound" "sslocate" "ssmautoopen" "standardsviolation" "startup" "surftab1"
"surftab2" "surftype" "surfu" "surfv" "syscodepage" "tabmode" "target"
"tdcreate" "tdindwg" "tducreate" "tdupdate" "tdusrtimer" "tduupdate"
"tempprefix" "texteval" "textfill" "textqlty" "textsize" "textstyle"
"thickness" "tilemode" "tooltips" "tracewid" "trackpath" "trayicons"
"traynotify" "traytimeout" "treedepth" "treemax" "trimmode" "tspacefac"
"tspacetype" "tstackalign" "tstacksize" "ucsaxisang" "ucsbase" "ucsfollow"
"ucsicon" "ucsname" "ucsorg" "ucsortho" "ucsview" "ucsvp" "ucsxdir" "ucsydir"
"undoctl" "undomarks" "unitmode" "updatethumbnail" "viewctr" "viewdir"
"viewmode" "viewsize" "viewtwist" "visretain" "vpmaximizedstate" "vsmax"
"vsmin" "whiparc" "wmfbkgnd" "wmfforegnd" "worlducs" "worldview" "writestat"
"xclipframe" "xedit" "xfadectl" "xloadctl" "xloadpath" "xrefctl" "xrefnotify"
"xreftype" "zoomfactor"))
  (setq sevals ())
  (setq num 0)
  (while (setq sub (nth num svlist))
         (setq sevals (cons (append (list sub) (list (getvar sub))) sevals))
         (setq num (1+ num)))
  (lisfi sevals) ; save to a file
  (write-line "System variable state saved to list Sevals.")
  (write-line "Run Ves to see changes.")
 (princ))
 ; Ŀ
 ;   C:Sev end.                                                            
 ; 

 ; Ŀ
 ;   Ves - see if any sysvars have changed.                                
 ; 
 (DEFUN C:VES ()
  (if (null sevals)
      (write-line "You have to run Sev first.")
      (ves sevals 0))
 (princ))
 ; Ŀ
 ;   C:Ves end.                                                            
 ; 

 ; Ŀ
 ;   Vesf: check the current state of system variables against values      
 ;   from a file made by Sev, indicate changes.                            
 ; 
 (DEFUN C:VESF (/ filnam atomlst)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Ask the user for a sysvar data file made by Sysave.                   
 ; 
  (setq filnam (getfiled "Sysvar Data File" (getvar "dwgprefix") "svs" 6))
 ; Ŀ
 ;   Read it back into a list of lists of strings.                         
 ; 
  (setq svlist (fstx filnam))
 ; Ŀ
 ;   And compare them to the current versions.  You can adjust the final   
 ;   number, which is the comparison accuracy.                             
 ; 
  (ves svlist 0.001)
 (princ))
 ; Ŀ
 ;   C:Vesf end.                                                           
 ; 

(prompt "C:SEV/C:VES/C:VESF")
(princ)
